/*
 * Decompiled with CFR 0.152.
 */
package com.br.bthbackend.backend.web;

import com.br.bthbackend.backend.domain.entity.Person;
import com.br.bthbackend.backend.service.PersonService;
import java.util.List;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/people"})
public class PersonController {
    private final PersonService service;

    @PostMapping
    @ResponseStatus(value=HttpStatus.CREATED)
    public Person create(@RequestBody Person body) {
        return this.service.create(body);
    }

    @PutMapping(value={"/{id}"})
    public Person update(@PathVariable Long id, @RequestBody Person body) {
        body.setId(id);
        return this.service.update(body);
    }

    @GetMapping(value={"/{id}"})
    public Person get(@PathVariable Long id) {
        return this.service.get(id);
    }

    @GetMapping
    public List<Person> list() {
        return this.service.list();
    }

    @DeleteMapping(value={"/{id}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void delete(@PathVariable Long id) {
        this.service.delete(id);
    }

    @Generated
    public PersonController(PersonService service) {
        this.service = service;
    }
}

