/*
 * Decompiled with CFR 0.152.
 */
package com.br.bthbackend.backend.web;

import com.br.bthbackend.backend.domain.repository.PaymentSessionRepository;
import com.br.bthbackend.backend.dto.payment.CreatePaymentLinkRequest;
import com.br.bthbackend.backend.dto.payment.CreatePaymentLinkResponse;
import com.br.bthbackend.backend.dto.payment.ProcessPaymentRequest;
import com.br.bthbackend.backend.model.PaymentSession;
import com.br.bthbackend.backend.service.CheckoutService;
import com.br.bthbackend.backend.service.PaymentLinkService;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/api/payment"})
@CrossOrigin(origins={"*"})
public class PaymentLinkController {
    private final PaymentLinkService linkService;
    private final PaymentSessionRepository repo;
    private final CheckoutService checkoutService;

    public PaymentLinkController(PaymentLinkService linkService, PaymentSessionRepository repo, CheckoutService checkoutService) {
        this.linkService = linkService;
        this.repo = repo;
        this.checkoutService = checkoutService;
    }

    @PostMapping(value={"/create-link"})
    public CreatePaymentLinkResponse createLink(@RequestBody CreatePaymentLinkRequest req) {
        return this.linkService.create(req);
    }

    @GetMapping(value={"/info/{id}"})
    public PaymentSession getInfo(@PathVariable String id) {
        return this.repo.findById((Object)id).orElse(null);
    }

    @PostMapping(value={"/process"})
    public Mono<ResponseEntity<Object>> processPayment(@RequestBody ProcessPaymentRequest request) {
        return this.checkoutService.processCreditCardPayment(request).map(response -> ResponseEntity.ok((Object)response)).onErrorResume(e -> {
            e.printStackTrace();
            return Mono.just((Object)ResponseEntity.badRequest().body((Object)("Erro ao processar: " + e.getMessage())));
        });
    }
}

