/*
 * Decompiled with CFR 0.152.
 */
package com.br.bthbackend.backend.web;

import com.br.bthbackend.backend.domain.entity.Contribution;
import com.br.bthbackend.backend.domain.entity.Person;
import com.br.bthbackend.backend.domain.repository.ContributionRepository;
import com.br.bthbackend.backend.domain.repository.PersonRepository;
import com.br.bthbackend.backend.dto.pagarme.customer.PagarmeCustomerRequest;
import com.br.bthbackend.backend.dto.pagarme.customer.PagarmeCustomerResponse;
import com.br.bthbackend.backend.dto.pagarme.order.PagarmeOrderItem;
import com.br.bthbackend.backend.dto.pagarme.order.PagarmeOrderRequest;
import com.br.bthbackend.backend.dto.pagarme.order.PagarmeOrderResponse;
import com.br.bthbackend.backend.dto.pagarme.order.PagarmePaymentRequest;
import com.br.bthbackend.backend.integration.PagarmeClient;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/api/pagarme"})
public class PagarmeController {
    private static final Logger log = LoggerFactory.getLogger(PagarmeController.class);
    private final PagarmeClient pagarmeClient;
    private final PersonRepository personRepo;
    private final ContributionRepository contributionRepo;

    @PostMapping(value={"/customers"})
    public Mono<ResponseEntity<PagarmeCustomerResponse>> createCustomer(@RequestBody PagarmeCustomerRequest request) {
        return this.pagarmeClient.createCustomer(request).map(ResponseEntity::ok).onErrorResume(WebClientResponseException.class, e -> Mono.just((Object)ResponseEntity.status((HttpStatusCode)e.getStatusCode()).body(null)));
    }

    @PostMapping(value={"/orders"})
    public Mono<ResponseEntity<PagarmeOrderResponse>> createOrder(@RequestBody PagarmeOrderRequest request) {
        log.info("Recebida requisi\u00e7\u00e3o em /api/pagarme/orders. Payload parsed ok.");
        String uniqueCode = "api-donation-" + String.valueOf(UUID.randomUUID());
        request.setCode(uniqueCode);
        return this.pagarmeClient.createOrder(request).map(response -> {
            try {
                this.saveContributionFromApi(request, response, uniqueCode);
                log.info("Contribui\u00e7\u00e3o salva no banco. C\u00f3digo: {}", (Object)uniqueCode);
            }
            catch (Exception e) {
                log.error("Erro cr\u00edtico ao salvar no banco: {}", (Object)e.getMessage(), (Object)e);
            }
            return ResponseEntity.ok((Object)response);
        }).onErrorResume(WebClientResponseException.class, e -> {
            log.error("Erro Pagar.me: {}", (Object)e.getResponseBodyAsString());
            return Mono.just((Object)ResponseEntity.status((HttpStatusCode)e.getStatusCode()).body(null));
        });
    }

    private void saveContributionFromApi(PagarmeOrderRequest request, PagarmeOrderResponse response, String code) {
        String customerId = request.getCustomerId();
        Person person = null;
        person = customerId != null && !customerId.isBlank() ? this.personRepo.findByPagarmeCustomerId(customerId).orElseGet(() -> this.createFallbackPerson(customerId)) : this.createFallbackPerson("sem-id");
        Integer amountCents = 0;
        String description = "Pedido via API";
        if (request.getItems() != null && !request.getItems().isEmpty()) {
            PagarmeOrderItem firstItem = (PagarmeOrderItem)request.getItems().get(0);
            amountCents = firstItem.getAmount();
            if (firstItem.getDescription() != null && !firstItem.getDescription().isEmpty()) {
                description = firstItem.getDescription();
            }
        } else if (request.getPayments() != null && !request.getPayments().isEmpty()) {
            amountCents = ((PagarmePaymentRequest)request.getPayments().get(0)).getAmount();
        }
        Contribution contribution = Contribution.builder().amount(BigDecimal.valueOf(amountCents.intValue()).divide(BigDecimal.valueOf(100L))).description(description).date(LocalDateTime.now()).code(code).status(response.getStatus()).paymentMethod("api_pix").person(person).pagarmeOrderId(response.getId()).build();
        this.contributionRepo.save((Object)contribution);
    }

    private Person createFallbackPerson(String ref) {
        return this.personRepo.findByEmail("integracao@api.com").orElseGet(() -> (Person)this.personRepo.save((Object)Person.builder().name("Cliente Integra\u00e7\u00e3o API").email("integracao@api.com").document("00000000000").documentType("cpf").pagarmeCustomerId(ref.startsWith("cus_") ? ref : null).build()));
    }

    @Generated
    public PagarmeController(PagarmeClient pagarmeClient, PersonRepository personRepo, ContributionRepository contributionRepo) {
        this.pagarmeClient = pagarmeClient;
        this.personRepo = personRepo;
        this.contributionRepo = contributionRepo;
    }
}

