/*
 * Decompiled with CFR 0.152.
 */
package com.br.bthbackend.backend.web;

import com.br.bthbackend.backend.domain.entity.EntityOrg;
import com.br.bthbackend.backend.service.EntityOrgService;
import java.util.List;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/entities"})
public class EntityOrgController {
    private final EntityOrgService service;

    @PostMapping
    @ResponseStatus(value=HttpStatus.CREATED)
    public EntityOrg create(@RequestBody EntityOrg body) {
        return this.service.create(body);
    }

    @PutMapping(value={"/{id}"})
    public EntityOrg update(@PathVariable Long id, @RequestBody EntityOrg body) {
        body.setId(id);
        return this.service.update(body);
    }

    @GetMapping(value={"/{id}"})
    public EntityOrg get(@PathVariable Long id) {
        return this.service.get(id);
    }

    @GetMapping
    public List<EntityOrg> list() {
        return this.service.list();
    }

    @DeleteMapping(value={"/{id}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void delete(@PathVariable Long id) {
        this.service.delete(id);
    }

    @Generated
    public EntityOrgController(EntityOrgService service) {
        this.service = service;
    }
}

