/*
 * Decompiled with CFR 0.152.
 */
package com.br.bthbackend.backend.service;

import com.br.bthbackend.backend.domain.repository.PaymentSessionRepository;
import com.br.bthbackend.backend.dto.payment.CreatePaymentLinkRequest;
import com.br.bthbackend.backend.dto.payment.CreatePaymentLinkResponse;
import com.br.bthbackend.backend.model.PaymentSession;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class PaymentLinkService {
    private final PaymentSessionRepository repo;
    @Value(value="${frontend.payment.url}")
    private String frontendUrl;

    public PaymentLinkService(PaymentSessionRepository repo) {
        this.repo = repo;
    }

    public CreatePaymentLinkResponse create(CreatePaymentLinkRequest req) {
        PaymentSession session = new PaymentSession();
        session.setAmount(req.amount());
        session.setDescription(req.description());
        session.setOrigin(req.origin());
        session = (PaymentSession)this.repo.save((Object)session);
        String url = this.frontendUrl + "?id=" + session.getId();
        return new CreatePaymentLinkResponse(url);
    }
}

