/*
 * Decompiled with CFR 0.152.
 */
package com.br.bthbackend.backend.service;

import com.br.bthbackend.backend.domain.entity.Contribution;
import com.br.bthbackend.backend.domain.entity.Person;
import com.br.bthbackend.backend.domain.repository.ContributionRepository;
import com.br.bthbackend.backend.domain.repository.PaymentSessionRepository;
import com.br.bthbackend.backend.domain.repository.PersonRepository;
import com.br.bthbackend.backend.dto.pagarme.customer.PagarmeCustomerRequest;
import com.br.bthbackend.backend.dto.pagarme.order.PagarmeBillingAddress;
import com.br.bthbackend.backend.dto.pagarme.order.PagarmeCardAttributes;
import com.br.bthbackend.backend.dto.pagarme.order.PagarmeCreditCard;
import com.br.bthbackend.backend.dto.pagarme.order.PagarmeOrderItem;
import com.br.bthbackend.backend.dto.pagarme.order.PagarmeOrderRequest;
import com.br.bthbackend.backend.dto.pagarme.order.PagarmeOrderResponse;
import com.br.bthbackend.backend.dto.pagarme.order.PagarmePaymentRequest;
import com.br.bthbackend.backend.dto.pagarme.order.PagarmePixTransaction;
import com.br.bthbackend.backend.dto.payment.ProcessPaymentRequest;
import com.br.bthbackend.backend.integration.PagarmeClient;
import com.br.bthbackend.backend.model.PaymentSession;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import reactor.core.publisher.Mono;

@Service
public class CheckoutService {
    private final PaymentSessionRepository sessionRepo;
    private final PersonRepository personRepo;
    private final ContributionRepository contributionRepo;
    private final PagarmeClient pagarmeClient;

    @Transactional
    public Mono<Object> processCreditCardPayment(ProcessPaymentRequest req) {
        PaymentSession session = (PaymentSession)this.sessionRepo.findById((Object)req.getSessionId()).orElseThrow(() -> new RuntimeException("Sess\u00e3o n\u00e3o encontrada"));
        String cleanCpf = req.getCpf().replaceAll("\\D", "");
        String uniqueOrderCode = "donation-" + String.valueOf(UUID.randomUUID());
        PagarmeCustomerRequest customer = PagarmeCustomerRequest.builder().name(req.getName()).email(req.getEmail()).document(cleanCpf).type("individual").build();
        PagarmeBillingAddress billingAddress = PagarmeBillingAddress.builder().line_1("10880, Malibu Point, Malibu Central").zip_code("90265").city("Malibu").state("CA").country("US").build();
        PagarmeCardAttributes cardAttributes = PagarmeCardAttributes.builder().billing_address(billingAddress).build();
        PagarmePaymentRequest payment = PagarmePaymentRequest.builder().paymentMethod("credit_card").amount(Integer.valueOf(session.getAmount())).creditCard(PagarmeCreditCard.builder().operation_type("auth_and_capture").installments(Integer.valueOf(1)).statement_descriptor("DOACAO BTH").card_token(req.getCardToken()).card(cardAttributes).build()).build();
        PagarmeOrderItem item = PagarmeOrderItem.builder().amount(Integer.valueOf(session.getAmount())).description(session.getDescription()).quantity(Integer.valueOf(1)).code(uniqueOrderCode).build();
        PagarmeOrderRequest orderRequest = PagarmeOrderRequest.builder().code(uniqueOrderCode).customer(customer).items(List.of(item)).payments(List.of(payment)).build();
        return this.pagarmeClient.createOrder(orderRequest).map(pagarmeResponse -> {
            this.saveLocalData(req, session, cleanCpf, uniqueOrderCode, pagarmeResponse, "credit_card");
            return pagarmeResponse;
        });
    }

    @Transactional
    public Mono<Object> processPixPayment(ProcessPaymentRequest req) {
        PaymentSession session = (PaymentSession)this.sessionRepo.findById((Object)req.getSessionId()).orElseThrow(() -> new RuntimeException("Sess\u00e3o n\u00e3o encontrada"));
        String cleanCpf = req.getCpf().replaceAll("\\D", "");
        String uniqueOrderCode = "donation-" + String.valueOf(UUID.randomUUID());
        PagarmeCustomerRequest customer = PagarmeCustomerRequest.builder().name(req.getName()).email(req.getEmail()).document(cleanCpf).type("individual").build();
        PagarmePaymentRequest payment = PagarmePaymentRequest.builder().paymentMethod("pix").amount(Integer.valueOf(session.getAmount())).pix(PagarmePixTransaction.builder().expiresIn(Integer.valueOf(3600)).build()).build();
        PagarmeOrderItem item = PagarmeOrderItem.builder().amount(Integer.valueOf(session.getAmount())).description(session.getDescription()).quantity(Integer.valueOf(1)).code(uniqueOrderCode).build();
        PagarmeOrderRequest orderRequest = PagarmeOrderRequest.builder().code(uniqueOrderCode).customer(customer).items(List.of(item)).payments(List.of(payment)).build();
        return this.pagarmeClient.createOrder(orderRequest).map(pagarmeResponse -> {
            this.saveLocalData(req, session, cleanCpf, uniqueOrderCode, pagarmeResponse, "pix");
            return pagarmeResponse;
        });
    }

    private void saveLocalData(ProcessPaymentRequest req, PaymentSession session, String cleanCpf, String code, PagarmeOrderResponse pagarmeResponse, String paymentMethod) {
        Person person = this.personRepo.findByDocument(cleanCpf).orElseGet(() -> Person.builder().document(cleanCpf).documentType("cpf").build());
        person.setName(req.getName());
        person.setEmail(req.getEmail());
        Person savedPerson = (Person)this.personRepo.save((Object)person);
        String statusToSave = pagarmeResponse.getStatus();
        if (statusToSave == null || statusToSave.isEmpty()) {
            statusToSave = "pending";
        }
        Contribution contribution = Contribution.builder().amount(BigDecimal.valueOf(session.getAmount().intValue()).divide(BigDecimal.valueOf(100L))).description(session.getDescription()).date(LocalDateTime.now()).code(code).status(statusToSave).paymentMethod(paymentMethod).person(savedPerson).pagarmeOrderId(pagarmeResponse.getId()).build();
        this.contributionRepo.save((Object)contribution);
    }

    @Generated
    public CheckoutService(PaymentSessionRepository sessionRepo, PersonRepository personRepo, ContributionRepository contributionRepo, PagarmeClient pagarmeClient) {
        this.sessionRepo = sessionRepo;
        this.personRepo = personRepo;
        this.contributionRepo = contributionRepo;
        this.pagarmeClient = pagarmeClient;
    }
}

