/*
 * Decompiled with CFR 0.152.
 */
package com.br.bthbackend.backend.integration;

import com.br.bthbackend.backend.config.PagarmeConfig;
import com.br.bthbackend.backend.dto.pagarme.customer.PagarmeCustomerRequest;
import com.br.bthbackend.backend.dto.pagarme.customer.PagarmeCustomerResponse;
import com.br.bthbackend.backend.dto.pagarme.order.PagarmeOrderRequest;
import com.br.bthbackend.backend.dto.pagarme.order.PagarmeOrderResponse;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import lombok.Generated;
import org.springframework.stereotype.Component;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

@Component
public class PagarmeClient {
    private final PagarmeConfig config;
    private WebClient webClient;

    private WebClient getClient() {
        if (this.webClient == null) {
            String encodedKey = Base64.getEncoder().encodeToString((this.config.getApiKey() + ":").getBytes(StandardCharsets.UTF_8));
            this.webClient = WebClient.builder().baseUrl(this.config.getApiUrl()).defaultHeader("Authorization", new String[]{"Basic " + encodedKey}).defaultHeader("Content-Type", new String[]{"application/json"}).defaultHeader("Accept", new String[]{"application/json"}).build();
        }
        return this.webClient;
    }

    public Mono<PagarmeCustomerResponse> createCustomer(PagarmeCustomerRequest request) {
        return ((WebClient.RequestBodySpec)this.getClient().post().uri("/customers", new Object[0])).bodyValue((Object)request).retrieve().bodyToMono(PagarmeCustomerResponse.class);
    }

    public Mono<PagarmeOrderResponse> createOrder(PagarmeOrderRequest request) {
        return ((WebClient.RequestBodySpec)this.getClient().post().uri("/orders", new Object[0])).bodyValue((Object)request).retrieve().bodyToMono(PagarmeOrderResponse.class);
    }

    @Generated
    public PagarmeClient(PagarmeConfig config) {
        this.config = config;
    }
}

