/*
 * Decompiled with CFR 0.152.
 */
package com.br.bthbackend.backend.domain.entity;

import com.br.bthbackend.backend.domain.entity.Contribution;
import com.br.bthbackend.backend.domain.entity.Person;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import lombok.Generated;

@Entity
@Table(name="contribution", uniqueConstraints={@UniqueConstraint(name="uk_contribution_code", columnNames={"code"})})
public class Contribution {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(nullable=false, precision=12, scale=2)
    private BigDecimal amount;
    private String description;
    @Column(nullable=false)
    private LocalDateTime date;
    @Column(nullable=false, unique=true)
    private String code;
    @Column(nullable=false)
    private String status;
    @Column(nullable=false)
    private String paymentMethod;
    @ManyToOne(optional=false)
    @JoinColumn(name="person_id")
    private Person person;
    private String pagarmeOrderId;

    @Generated
    public static ContributionBuilder builder() {
        return new ContributionBuilder();
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public BigDecimal getAmount() {
        return this.amount;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public LocalDateTime getDate() {
        return this.date;
    }

    @Generated
    public String getCode() {
        return this.code;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public String getPaymentMethod() {
        return this.paymentMethod;
    }

    @Generated
    public Person getPerson() {
        return this.person;
    }

    @Generated
    public String getPagarmeOrderId() {
        return this.pagarmeOrderId;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setDate(LocalDateTime date) {
        this.date = date;
    }

    @Generated
    public void setCode(String code) {
        this.code = code;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setPaymentMethod(String paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    @Generated
    public void setPerson(Person person) {
        this.person = person;
    }

    @Generated
    public void setPagarmeOrderId(String pagarmeOrderId) {
        this.pagarmeOrderId = pagarmeOrderId;
    }

    @Generated
    public Contribution() {
    }

    @Generated
    public Contribution(Long id, BigDecimal amount, String description, LocalDateTime date, String code, String status, String paymentMethod, Person person, String pagarmeOrderId) {
        this.id = id;
        this.amount = amount;
        this.description = description;
        this.date = date;
        this.code = code;
        this.status = status;
        this.paymentMethod = paymentMethod;
        this.person = person;
        this.pagarmeOrderId = pagarmeOrderId;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Contribution)) {
            return false;
        }
        Contribution other = (Contribution)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Contribution;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

